"use client";
import React, { useEffect, useState } from "react";
import { useSession } from "@/app/contexts/SessionContext.jsx";
import { getEmpresa } from "@/api/empresas.jsx"

export default function EmpresaDetalle({ params }) {

  const { user } = useSession();
  const [empresa, setEmpresa] = useState();

  const [modalConfirmar, setModalConfirmar] = useState(false)

  useEffect(() => {
    const fetchData = async () => { 
        try {
          if (user && user.token) {
            const empresaData = await getEmpresa(params.id, user.token)
            setEmpresa(empresaData)
            console.log(empresaData)
          }
        } catch (error) {
          console.error('Error al obtener las empresas:', error.message);
        }
    };

    fetchData();
  }, [user]);

  const handleEnableClick = () => {
    const updatedEmpresa = {...empresa}
    updatedEmpresa.vigente = true
    setEmpresa(updatedEmpresa)
    console.log("enabled")
  }

  const handleDisableClick = () => {
    const updatedEmpresa = {...empresa}
    updatedEmpresa.vigente = false
    setEmpresa(updatedEmpresa)
    console.log("disabled")
  }

  const handleEditClick = () => {
    console.log("Edit")
  }

  return (
    <section className="">
      <div className="container mx-auto py-8">

      <div className="flex justify-between">
      <h2 className="text-2xl font-bold mb-4">Detalle de Empresa</h2>

      { empresa && 
        <div className="flex gap-4">
          <button className="bg-yellow-400 px-4 py-2 mb-4 rounded hover:bg-yellow-300"
            onClick = {handleEditClick}>
              Editar
            </button>
          <button className={empresa.vigente ? 
          "bg-red-500 px-4 py-2 mb-4 rounded hover:bg-red-300" :
          "bg-blue-500 px-4 py-2 mb-4 rounded hover:bg-blue-300"}
            onClick = {empresa.vigente ? handleDisableClick : handleEnableClick }>
            {empresa.vigente ? 'Deshabilitar' : 'Habilitar'}</button>
        </div> } 
      </div>
      

      { empresa && 
      <div className="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4">
        <div className="grid grid-cols-3 gap-4">
        
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Nombre Empresa:</label>
          <p>{empresa.nombre_empresa}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Representante Legal:</label>
          <p>{empresa.representante_legal}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">RUT Empresa:</label>
          <p>{empresa.rut_empresa}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Dirección Empresa:</label>
          <p>{empresa.direccion_emp}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Tipo de Sociedad:</label>
          <p>{empresa.tipo_sociedad}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Nombre Ejecutivo:</label>
          <p>{empresa.nombre_ejecutivo}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Teléfono Ejecutivo:</label>
          <p>{empresa.telefono_ejecutivo}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Correo Ejecutivo:</label>
          <p>{empresa.correo_ejecutivo}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Abreviación:</label>
          <p>{empresa.abreviacion}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Vigente:</label>
          <p>{empresa.vigente ? 'Sí' : 'No'}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Postulaciones:</label>
          <p>{empresa.postulaciones ? 'Sí' : 'No'}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Rubro:</label>
          <p>{empresa.rubro ? 'Sí' : 'No'}</p>
        </div>

        { empresa.usuario_admin && 
        <div className="mb-4">          
          <label className="block text-gray-700 text-sm font-bold mb-2">Administrador:</label>
          <p>Nombre: {empresa.usuario_admin.nombre_usuario}</p>
          <p>RUT: {empresa.usuario_admin.rut_usuario}</p>
          <p>Correo: {empresa.usuario_admin.correo_usuario}</p>
          <p>Teléfono: {empresa.usuario_admin.telefono_usuario}</p>
        </div>
        }

        { empresa.mercado_publico &&
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Mercado Público:</label>
          <p>ID: {empresa.mercado_publico.mercado_publico_id}</p>
          <p>Nombre: {empresa.mercado_publico.mercado_publico_nombre}</p>
        </div>
        }
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Presentación Empresa:</label>
          <p>{empresa.presentacion_empresa}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Misión Empresa:</label>
          <p>{empresa.mision_empresa}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Visión Empresa:</label>
          <p>{empresa.vision_empresa}</p>
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 text-sm font-bold mb-2">Descripción Servicios:</label>
          <p>{empresa.descripcion_servicios}</p>
        </div>
      </div>}  
    </div>

    {modalConfirmar && 
    <div>
      ¿Desea confirmar el cambio?
      <button>Sí</button>
      <button>No</button>
    </div>
    }

    </section>
  );
}
